********************************************************************************
* Program to import daily bond prices from FRED
********************************************************************************
clear
set more off
local home = "/Users/sbelz"
cd "`home'/bpea_replication/data/raw data/"
********************************************************************************
* You'll be prompted to give a FRED API key; get one here:
* https://research.stlouisfed.org/useraccount/apikeys 
********************************************************************************
import fred DAAA BAMLC0A1CAAAEY BAMLC0A1CAAA BAMLC0A4CBBB BAMLC0A4CBBBEY ///
		BAMLH0A3HYC BAMLH0A3HYCEY BAMLH0A0HYM2 BAMLH0A0HYM2EY DBAA DGS10 VIXCLS, ///
		daterange(1980-01-01 2020-08-10) ///
		aggregate(daily,eop)
		
rename BAMLC0A1CAAAEY aaa_bofa
ren BAMLC0A1CAAA aaaspr_bofa
ren BAMLC0A4CBBBEY bbb_bofa
ren BAMLC0A4CBBB bbbspr_bofa
ren BAMLH0A3HYC cccspr_bofa
ren BAMLH0A3HYCEY ccc_bofa
ren BAMLH0A0HYM2 hyspr_bofa
ren BAMLH0A0HYM2EY hy_bofa
ren DAAA aaa_moodys
ren DBAA baa_moodys

save "../yields.dta", replace
export delimited "yields.csv", replace
