********************************************************************************
* Program to generate tables of bond spread changes around event days
********************************************************************************
clear
set more off
local home = "/Users/sbelz" /* Edit this variable */
cd "`home'/bpea_replication/data"
set scheme s1color

********************************************************************************
* CORPORATE BOND SPREADS
********************************************************************************
* Data from FRED
use yields, clear
qui merge 1:m daten using covidevents, nogen
keep if daten > date("31dec2019", "DMY")

bcal create bonds, from(daten) replace
gen bdate = bofd("bonds", daten)
format bdate %tbbonds
tsset bdate

* SGH: Base changes on trading days rather than calendar days
drop if aaaspr_bofa == .
sort bdate
gen t = _n
tsset t

* Calculate 3, 4, and 7-day differences
foreach var of varlist *spr* {
	
	* Forward fill so that we don't get . on Mondays or Tuesdays 
	* For some reason stata ts operators don't get this	even with bcal
	replace `var' = `var'[_n-1] if missing(`var') 
	
	gen d3a_`var' = 100*(f2.`var' - l1.`var')
	gen d3b_`var' = 100*(f3.`var' - `var')
	gen d4a_`var' = 100*(f2.`var' - l2.`var')
	gen d4b_`var' = 100*(f3.`var' - l1.`var')
	gen d7a_`var' = 100*(f6.`var' - l1.`var')
	gen d7b_`var' = 100*(f4.`var' - l3.`var')
}

* Make Tables
********************************************************************************
keep if includetable == 1
sort fed health macro daten
* got to be a more efficient way to do this 

foreach diff in d3a d3b d4a d4b d7a d7b {
	preserve 
	keep daten event `diff'_aaaspr `diff'_aaspr `diff'_aspr `diff'_bbbspr `diff'_hyspr `diff'_bbspr `diff'_bspr `diff'_cccspr
	order daten event `diff'_aaaspr `diff'_aaspr `diff'_aspr `diff'_bbbspr `diff'_hyspr `diff'_bbspr `diff'_bspr `diff'_cccspr
	
	foreach var of varlist `diff'_aaaspr `diff'_aaspr `diff'_aspr `diff'_bbbspr `diff'_hyspr `diff'_bbspr `diff'_bspr `diff'_cccspr {
		replace `var' = round(`var')
	}
	rename `diff'_aaaspr AAA
	rename `diff'_aaspr AA
	rename `diff'_aspr A
	rename `diff'_bbbspr BBB
	rename `diff'_hyspr HY
	rename `diff'_bbspr BB
	rename `diff'_bspr B	
	rename `diff'_cccspr CCC
	export delimited "../output/`diff'_tab_new.csv", replace
	restore
}
