********************************************************************************
* Program to import SLOOS data from FRED
********************************************************************************
clear
set more off
local home = "/Users/sbelz"
cd "`home'/bpea_replication/data/"
********************************************************************************
* You'll be prompted to give a FRED API key; get one here:
* https://research.stlouisfed.org/useraccount/apikeys 
********************************************************************************
import fred USREC DRTSCILM ///
		CP A191RL1Q225SBEA UNRATE CCSA, ///
		daterange(1980-01-01 2020-08-10) ///
		aggregate(quarterly,avg)
		
ren DRTSCILM sloos_ci
ren CP cp
ren A191RL1Q225SBEA gdph
ren UNRATE unrate
ren CCSA uiclaims

gen yq = yq(year(daten), quarter(daten))
format yq %tq
drop date*

save sloos, replace
export delimited "raw data/fredquarterly.csv", replace
