*==============================================================================*
* Program to generate monthly time series figures
*==============================================================================*
clear
set more off
* Edit this line
local home = "/Users/sbelz"
cd "`home'/bpea_replication/data"
set scheme s1color

*==============================================================================*
* CORPORATE BOND SPREADS
* Note: Spreads are calculated by ICE BofAML; they are the calculated spreads 
* between a computed OAS index of all bonds in a given rating category and a 
* spot Treasury curve
*==============================================================================*
* Data from FRED - Bloomberg doesn't have any indices that go back further
use yields 
gen ym = ym(year(daten), month(daten))
format ym %tm
drop date*

* Aggregate to monthly series
collapse (mean) a* b* hy* ccc* D*, by(ym)

* Merge recession data
merge 1:m ym using nberreces, nogen
* replace usrec = . if usrec == 0

local startyr = 1996
keep if ym >= ym(`startyr',1)

* Calculate unconditional averages of the series
foreach var of varlist aaa_moodys-DGS10 {
	egen mean_`var' = mean(`var')
	local mean_`var' = mean_`var'
}

* Macros to place year labels between tick marks
forvalues y = `startyr'(4)2020 {
	local midyr `midyr' `=ym(`y',1)'
}
forvalues y = `startyr'(1)2020 {
	local firstofyr `firstofyr' `=ym(`y',1)'
}

* Recession shading objects
gen shade = usrec
local shadingcall shade ym, color(gs14%40)

* IG Spreads	
*==============================================================================*
replace shade = usrec*8
twoway (bar `shadingcall') ///
	   (line aspr_b bbbspr_b ym, lcolor(dkgreen orange_red)) ///
	   (line mean_aspr mean_bbbspr ym,  lpattern(dash dash) lcolor(dkgreen orange_red) yaxis(2)), ///
	   xlabel(`midyr', format(%tmCY)) xtitle("") ///
	   xticks(`firstofyr', tlength(0.5)) ///
	   ylabel(0(1)8, angle(horizontal)) ///
	   ylabel(0(1)8, angle(horizontal) axis(2)) ytitle("", axis(2)) ///	   
	   legend(order(2 "A" 3 "BBB" 4 "Mean A, 1996-2020" 5 "Mean BBB, 1996-2020"))
	   
graph export "../output/monthlyIG.png", replace

* HY Spreads	   	   
*==============================================================================*
replace shade = usrec*40
twoway (bar `shadingcall') ///
	   (line hyspr_b cccspr_b ym, lcolor(navy cranberry)) ///
	   (line mean_bspr mean_cccspr ym,  lpattern(dash dash) lcolor(navy cranberry) yaxis(2)), ///
	   xlabel(`midyr', format(%tmCY)) xtitle("") ///
	   xticks(`firstofyr', tlength(0.5)) ///
	   ylabel(0(5)40, angle(horizontal)) ///
	   ylabel(0(5)40, angle(horizontal) axis(2)) ytitle("", axis(2)) ///	   
	   legend(order(2 "B" 3 "CCC" 4 "Mean B, 1996-2020" 5 "Mean CCC, 1996-2020"))
	   
graph export "../output/monthlyHY.png", replace


