	   
******************************************************************************************************************************
***********************************************************************************************************************************
** Difference Specifications. IV [First-Stage] and 2SLS Specifications. Construction, Unemployment and Voting
** Baseline and Robustness [Appendix]
** Appendix Tables 4, 5 and 7
************************************************************************************************************************************
******************************************************************************************************************************

	   
** Appendix Table 4. Post-Pre Crisis Difference in Unemployment [2017-2009]-[2008-2000] and Pre-Crisis Construction Share
**************************************************************************************************************************
**************************************************************************************************************************     
set more off
** Panel A. Construction in 2007
xi: reg S9.totunemp_sm8  L10.sh_const		 	if nv1==0 & year==2017, r cluster(cntry)
est store b1r

xi: reg S9.totunemp_sm8  L10.sh_const  L10.(sh_agri sh_finan sh_trade sh_govt) 			if nv1==0 & year==2017, r cluster(cntry)
est store b2r

xi: reg S9.totunemp_sm8  L10.sh_const  i.group 	if nv1==0 & year==2017, r cluster(cntry)
est store b3r

xi: reg S9.totunemp_sm8  L10.sh_const  L10.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2017, r cluster(cntry)
est store b4r
	
	
** Panel B. Construction in 2003	
xi: reg S9.totunemp_sm8  L14.sh_const  				 	if nv1==0 & year==2017, r cluster(cntry)
est store b1rr

xi: reg S9.totunemp_sm8  L14.sh_const  L14.(sh_agri sh_finan sh_trade sh_govt) 			if nv1==0 & year==2017, r cluster(cntry)
est store b2rr

xi: reg S9.totunemp_sm8  L14.sh_const  i.group 			if nv1==0 & year==2017, r cluster(cntry)
est store b3rr

xi: reg S9.totunemp_sm8  L14.sh_const  L14.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2017, r cluster(cntry)
est store b4rr

	   
	   
** Appendix Table 4. Pre-Crisis Construction Share and Unemployment Dynamics during the Crisis OLS Estimates				
***************************************************************************************************************************
***************************************************************************************************************************
** column 1. no controls
** column 2. initial pre-crisis industrial composition
** column 3. country group constants
** column 4. country group constants and initial pre-crisis industrial composition
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Industrial Share in 2007
***************************************************************************************************************************
estout b1r b2r b3r b4r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L10.sh_const)  stats(r2_a r2_w  N N_clust, fmt(%9.3f %9.0g) labels(r-square within_r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  
	     
	   
** Panel B. Industrial Share in 2003
***************************************************************************************************************************
estout b1rr b2rr b3rr b4rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L14.sh_const)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	
	
	
** Appendix Table 5. Pre-Crisis Construction and Unemployment Dynamics during the Crisis OLS specifications					
***************************************************************************************************************************
***************************************************************************************************************************    
set more off
**  Panel A.   Industrial Share in 2007
***************************************************************************************************************************
**  2016-2008
xi: reg S8.totunemp  L9.sh_const  L9.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2016, r cluster(cntry)
est store b1rt

**  2015-2008
xi: reg S7.totunemp  L8.sh_const  L8.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2015, r cluster(cntry)
est store b2rt

**  2014-2008
xi: reg S6.totunemp  L7.sh_const  L7.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2014, r cluster(cntry)
est store b3rt

** 2013-2008
xi: reg S5.totunemp  L6.sh_const  L6.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2013, r cluster(cntry)
est store b4rt
	
** 2012-2008
xi: reg S4.totunemp L5.sh_const  L5.(sh_agri sh_finan sh_trade sh_govt) i.group 			if nv1==0 & year==2012, r cluster(cntry)
est store b5rt


**  Panel B.  Industrial Share in 2004-2007 
***************************************************************************************************************************
**  2016-2008
set more off
xi: reg S8.totunemp  L9.sh_const_sm3  L9.(sh_agri_sm3 sh_finan_sm3 sh_trade_sm3 sh_govt_sm3) i.group 			if nv1==0 & year==2016, r cluster(cntry)
est store b1rtt

**  2015-2008
xi: reg S7.totunemp  L8.sh_const_sm3  L8.(sh_agri_sm3 sh_finan_sm3 sh_trade_sm3 sh_govt_sm3) i.group 			if nv1==0 & year==2015, r cluster(cntry)
est store b2rtt

**  2014-2008
xi: reg S6.totunemp  L7.sh_const_sm3  L7.(sh_agri_sm3 sh_finan_sm3 sh_trade_sm3 sh_govt_sm3) i.group 			if nv1==0 & year==2014, r cluster(cntry)
est store b3rtt

** 2013-2008
xi: reg S5.totunemp  L6.sh_const_sm3  L6.(sh_agri_sm3 sh_finan_sm3 sh_trade_sm3 sh_govt_sm3) i.group 			if nv1==0 & year==2013, r cluster(cntry)
est store b4rtt
	
** 2012-2008
xi: reg S4.totunemp L5.sh_const_sm3  L5.(sh_agri_sm3 sh_finan_sm3 sh_trade_sm3 sh_govt_sm3) i.group 			if nv1==0 & year==2012, r cluster(cntry)
est store b5rtt


** Appendix Table 5. Pre-Crisis Construction and Unemployment Dynamics during the Crisis OLS specifications					
***************************************************************************************************************************
***************************************************************************************************************************  
** column (1). 2016-2008
** column (2). 2015-2008
** column (3). 2014-2008
** column (4). 2013-2008
** column (5). 2012-2008
***************************************************************************************************************************
***************************************************************************************************************************	
**  Panel A.   Industrial Share in 2007
***************************************************************************************************************************
**  2016-2008estout b1rt b2rt b3rt b4rt b5rt, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L9.sh_const L8.sh_const L7.sh_const L6.sh_const L5.sh_const)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  	   

**  Panel B.  Industrial Share in 2004-2007 
***************************************************************************************************************************estout b1rtt b2rtt b3rtt b4rtt b5rtt, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L9.sh_const_sm3 L8.sh_const_sm3 L7.sh_const_sm3 L6.sh_const_sm3 L5.sh_const_sm3)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  	   
		   

		   
  

** Appendix Table 7. 2SLS Difference Specifications. 
** Post-Pre Crisis Difference in Voting [2017-2013]-[2008-2004], Difference in Unemployment and Pre-Crisis Construction Share
******************************************************************************************************************************
******************************************************************************************************************************
set more off	   
 ** Panel A. No Controls
 xi: ivreg2 S9.extreme_per_sm4 	(S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
 est store kk1  
	  
 xi: ivreg2 S9.extreme_perel_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
est store kk2  
	   
 xi: ivreg2 S9.extreme_perer_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
est store kk3  
	  
 xi: ivreg2 S9.extreme_perp_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
est store kk4  

xi: ivreg2 S9.extreme_perae_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
est store kk5  
	  
 xi: ivreg2 S9.part_sm4 		(S9.totunemp_sm4 = L10.sh_const_sm4)   if nv==0 & year==2017, r cluster(cntry)
 est store kk6  
 
 
 
** Panel B. Country-Group Constants 
 xi: ivreg2 S9.extreme_per_sm4 	(S9.totunemp_sm4 = L10.sh_const_sm4)  i.group if nv==0 & year==2017, r cluster(cntry)
 est store kk1r  
	  
 xi: ivreg2 S9.extreme_perel_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)  i.group  if nv==0 & year==2017, r cluster(cntry)
est store kk2r  
	   
 xi: ivreg2 S9.extreme_perer_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)  i.group  if nv==0 & year==2017, r cluster(cntry)
est store kk3r  
	  
 xi: ivreg2 S9.extreme_perp_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   i.group  if nv==0 & year==2017, r cluster(cntry)
est store kk4r  

xi: ivreg2 S9.extreme_perae_sm4 (S9.totunemp_sm4 = L10.sh_const_sm4)   i.group  if nv==0 & year==2017, r cluster(cntry)
est store kk5r  
	  
 xi: ivreg2 S9.part_sm4 		(S9.totunemp_sm4 = L10.sh_const_sm4)   i.group  if nv==0 & year==2017, r cluster(cntry)
 est store kk6r  
 
 

** Appendix Table 7. Unemployment and Voting for Anti-Establishment Parties Before and After the Crisis 2SLS Difference Specifications.  
** Post-Crisis Average [2017-2013] - Pre-Crisis Average [2004-2008]						
******************************************************************************************************************************
******************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
******************************************************************************************************************************
******************************************************************************************************************************
** Panel A. General Constant
******************************************************************************************************************************
 estout kk1 kk2 kk3 kk4 kk5 kk6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm4) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Country-Group Constants 
******************************************************************************************************************************
estout kk1r kk2r kk3r kk4r kk5r kk6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm4) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   		   
		