
***************************************************************************************************************************
***************************************************************************************************************************
** Program File. Generating All Figures (Main Paper and Apendix)
***************************************************************************************************************************
***************************************************************************************************************************


***************************************************************************************************************************
***************************************************************************************************************************
**Main Paper Figures
***************************************************************************************************************************
***************************************************************************************************************************

clear all

set more off

global files="C:/Users/User/Dropbox/ETC"

cd "$files"

use "$files/voting_ESS_NUTS2", clear

gen time = 0
replace time=1 if year>2008

gen nv2=nv
replace nv2=1 if nuts=="DK"

***************************************************************************************************************************
**Figure 1. Evolution of Unemployment (NUTS 2, 26 countries)
***************************************************************************************************************************

sort year
egen totunempnorth=mean(totunemp) if group=="North", by(year)
egen totunempsouth=mean(totunemp) if group=="South", by(year)
egen totunemptrans=mean(totunemp) if group=="Transition", by(year)
egen totunempcentre=mean(totunemp) if group=="Centre", by(year)

rename totunempnorth North
rename totunempsouth South
rename totunemptrans East
rename totunempcentre Center

	
**Figure 1a: Unemployment by region
***************************************************************************************************************************
line North South East Center year if nv1==0, legend(size(medsmall)) ///
title("Unemployment rate, 200016", size(medium)) ///
xtitle("Year", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure1a.eps", as(eps) replace 

	
**Figure1b: Unemployment before and after the crisis
***************************************************************************************************************************
twoway histogram totunemp if time==0 & nv1==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram totunemp if time==1 & nv1==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Distribution of total unemployment", size(small)) ///
subtitle("", size(small)) ///
xtitle("Unemployment rate", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure1b.eps", as(eps) replace 



***************************************************************************************************************************	
**Figure 2: Antiestablishment Vote before and after the crisis (NUTS 2, 26 countries)
***************************************************************************************************************************

twoway histogram extreme_per if time==0 & nv==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram extreme_per if time==1 & nv==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("The Distribution of Voting for Anti-establishment Parties, Before and After the Crisis", size(small)) ///
subtitle("", size(small)) ///
xtitle("Voting share", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure2.eps", as(eps) replace  
	


***************************************************************************************************************************	
**Figure 3: ESS Variables before and after the crisis (NUTS 2, 24 countries)
***************************************************************************************************************************

**Figure 3a: Trust in national Parliament
***************************************************************************************************************************
twoway histogram trstprl_new if time==0 & nv2==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram trstprl_new if time==1 & nv2==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("National Parliaments", size(small)) ///
subtitle("", size(small)) ///
xtitle("Level of trust", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure3a.eps", as(eps) replace 


**Figure 3b: Trust in legal system
***************************************************************************************************************************	
twoway histogram trstlgl_new if time==0 & nv2==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram trstlgl_new if time==1 & nv2==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Legal System", size(small)) ///
subtitle("", size(small)) ///
xtitle("Level of trust", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure3b.eps", as(eps) replace 


**Figure 3c: Trust in police
***************************************************************************************************************************
twoway histogram trstplc_new if time==0 & nv2==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram trstplc_new if time==1 & nv2==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Police", size(small)) ///
subtitle("", size(small)) ///
xtitle("Level of trust", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure3c.eps", as(eps) replace 


**Figure 3d: Trust in European Parliament
***************************************************************************************************************************
twoway histogram trstep_new if time==0 & nv2==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram trstep_new if time==1 & nv2==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("European Parliament", size(small)) ///
subtitle("", size(small)) ///
xtitle("Level of trust", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figure3d.eps", as(eps) replace 





***************************************************************************************************************************
**Figure 4. Antiestablishment Voting and Unemployment before and after the crisis (NUTS 2, 26 countries)
***************************************************************************************************************************

sort nuts1 cntry1 group1 time

collapse (mean) nv nv1 nv2 lppsgdp  totunemp	Electorate	Voters	ValidVotes	part blankinv_per rowtotal	extreme_per	extreme_perer extreme_perel extreme_perp extreme_perae BlankInvalid	extreme_new	extreme_right_new	extreme_left_new	ipstrgv_new	impsafe_new	 freehms_new	imsmetn_new	ppltrst_new	pplfair_new	pplhlp_new	trstprl_new	trstlgl_new	trstplc_new	trstplt_new	trstep_new	trstun_new	vote_new	contplt_new	clsprty_new	lrscale_new	stflife_new	stfeco_new	stfgov_new	stfdem_new	imdfetn_new	impcntr_new	imbgeco_new	imueclt_new	imwbcnt_new	 	ctzcntr_new	brncntr_new 	trstprt_new	euftf_new	sh_agri	sh_indus	sh_const	sh_trade	sh_finan	sh_govt	pboafvr_new	pbofvrw_new	pbofvr_new	net_migr_fl	educlev_5to8	educlev_0to2	educlev_3to8	educlev_3to4, by(nuts1 cntry1 group1 time)		  

save "$files/period_means_NUTS2.dta",replace

by nuts1: gen dtotunemp=(totunemp[2]-totunemp[1])
by nuts1: gen dextreme_per=(extreme_per[2]-extreme_per[1])

separate dtotunemp, by(group1)
separate dextreme_per, by(group1)

keep  if time==0

**Figure 4a: Antiestablishment vote
***************************************************************************************************************************
twoway (scatter  dextreme_per?  dtotunemp if nv==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_per dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Anti-establishment parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Eurostat", size(vsmall)) 
graph export "$files/figure4a.eps", as(eps) replace 



***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************

use "$files/period_means_NUTS2.dta",clear

by nuts1: gen dtotunemp=(totunemp[2]-totunemp[1])
by nuts1: gen dgdp=(lppsgdp[2]-lppsgdp[1])
by nuts1: gen dextreme_per=(extreme_per[2]-extreme_per[1])
by nuts1: gen dextreme_perer=(extreme_perer[2]-extreme_perer[1])
by nuts1: gen dextreme_perel=(extreme_perel[2]-extreme_perel[1])
by nuts1: gen dextreme_perp=(extreme_perp[2]-extreme_perp[1])
by nuts1: gen dextreme_perae=(extreme_perae[2]-extreme_perae[1])

separate dtotunemp, by(group1)
separate dgdp, by(group1)
separate dextreme_per, by(group1)
separate dextreme_perer, by(group1)
separate dextreme_perel, by(group1)
separate dextreme_perp, by(group1)
separate dextreme_perae, by(group1)

keep  if time==0


**Figure 4b: Radical left vote
***************************************************************************************************************************
twoway (scatter  dextreme_perel?  dtotunemp if nv==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perel dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Radical left parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Eurostat", size(vsmall)) 
graph export "$files/figure4b.eps", as(eps) replace 


**Figure 4c: Far-right vote
***************************************************************************************************************************
twoway (scatter  dextreme_perer?  dtotunemp if nv==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perer dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Far-right parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Eurostat", size(vsmall)) 
graph export "$files/figure4c.eps", as(eps) replace 


**Figure 4d: Populist vote
***************************************************************************************************************************
twoway (scatter  dextreme_perp?  dtotunemp if nv==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perp dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Populist parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Eurostat", size(vsmall))
graph export "$files/figure4d.eps", as(eps) replace 


**Figure 4e: Eurosceptic/separatist vote
***************************************************************************************************************************
twoway (scatter  dextreme_perae?  dtotunemp if nv==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perae dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Eurosceptic parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Eurostat", size(vsmall))  
graph export "$files/figure4e.eps", as(eps) replace



***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************

use "$files/voting_ESS_NUTS2", clear

set more off
gen time = 0
replace time=1 if year>2008

gen nv2=nv
replace nv2=1 if nuts=="DK"

**Smoothing
tssmooth ma sh_const_sm3 = sh_const, window(3 1) 
tssmooth ma sh_const_sm4 = sh_const, window(4 1) 

tssmooth ma totunemp_sm3 = totunemp, window(3 1) 
tssmooth ma totunemp_sm4 = totunemp, window(4 1)

tssmooth ma extremeper_sm8  = extreme_per, window(8 1)
tssmooth ma totunemp_sm8 = totunemp, window(8 1)


***************************************************************************************************************************
**Figure 5: Construction Share and Unemployment (NUTS 2, 26 countries)
***************************************************************************************************************************

set more off
xi: reg totunemp_sm8 i.nuts1 i.year  if nv==0 &  extremeper_sm8!=., robust cluster(cntry)
predict resid_totunemp, residuals
sum resid_totunemp

xi: reg sh_const_sm3 i.nuts1 i.year  if nv==0 & extremeper_sm8!=., robust cluster(cntry)
predict resid_shconst, residuals
sum resid_shconst

separate resid_totunemp, by(group1)
separate resid_shconst, by(group1)


**Figure 5a:  Construction share and total unemployment, controlling for region and year fixed effects
***************************************************************************************************************************
twoway (scatter  resid_shconst?  resid_totunemp,    mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    resid_shconst resid_totunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Construction share and unemployment", size(small)) subtitle("Controlling for region and time (year) fixed effects", size(vsmall))  legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Share of employment in construction", size(small)) note("Source: Eurostat", size(vsmall))  
graph export "$files/figure5a.eps", as(eps) replace 



clear
set more off

use "$files/voting_ESS_NUTS2.dta"
gen time = 0
replace time=1 if year>2008

gen nv2=nv
replace nv2=1 if nuts=="DK"

**Smoothing

tssmooth ma sh_const_sm3 = sh_const, window(3 1) 
tssmooth ma sh_const_sm4 = sh_const, window(4 1) 

tssmooth ma sh_finan_sm3 = sh_finan, window(3 1) 
tssmooth ma sh_finan_sm4 = sh_finan, window(4 1)

tssmooth ma sh_indus_sm3 = sh_indus, window(3 1) 
tssmooth ma sh_indus_sm4 = sh_indus, window(4 1)

tssmooth ma sh_trade_sm3 = sh_trade, window(3 1) 
tssmooth ma sh_trade_sm4 = sh_trade, window(4 1)

tssmooth ma sh_agri_sm3 = sh_agri, window(3 1) 
tssmooth ma sh_agri_sm4 = sh_agri, window(4 1)

tssmooth ma sh_govt_sm3 = sh_govt, window(3 1) 
tssmooth ma sh_govt_sm4 = sh_govt, window(4 1)

tssmooth ma extremeper_sm8  = extreme_per, window(8 1)
tssmooth ma totunemp_sm8 = totunemp, window(8 1)


set more off
xi: reg totunemp_sm8 i.nuts1 i.year sh_finan_sm3  sh_agri_sm3 sh_trade_sm3 sh_govt_sm3 if nv==0 &  extremeper_sm8!=., robust cluster(cntry)

predict resid_totunemp, residuals
sum resid_totunemp

xi: reg sh_const_sm3 i.nuts1 i.year sh_finan_sm3  sh_agri_sm3 sh_trade_sm3 sh_govt_sm3 if nv==0 & extremeper_sm8!=., robust cluster(cntry)

predict resid_shconst, residuals
sum resid_shconst

separate resid_totunemp, by(group1)
separate resid_shconst, by(group1)


**Figure 5b:  Construction share and total unemployment,controlling for region, year fixed effects and industrial composition
***************************************************************************************************************************
twoway (scatter  resid_shconst?  resid_totunemp ,    mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    resid_shconst resid_totunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Construction share and unemployment", size(small)) subtitle("Controlling for region, time (year) FE and industrial composition", size(vsmall))  legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Share of employment in construction", size(small)) note("Source: Eurostat", size(vsmall))  
graph export "$files/figure5b.eps", as(eps) replace 




sort nuts1 year 
gen L10sh_const_sm3=L10.sh_const_sm3 if year==2017

separate L10sh_const_sm3, by(group1)


**Figure 5c:  Initial construction share and change in unemployment, before and after the crisis
***************************************************************************************************************************
twoway (scatter  L10sh_const_sm3?  S9.totunemp_sm8 if year==2017 & S9.extremeper_sm8!=. ,    mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    L10sh_const_sm3 S9.totunemp_sm8,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Initial construction share and change in unemployment", size(small)) subtitle("Before and After the Crisis", size(vsmall))  legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Initial share of employment in construction", size(small)) note("Source: Eurostat", size(vsmall))  
graph export "$files/figure5c.eps", as(eps) replace 




drop resid_totunemp*  resid_shconst*
xi: reg totunemp_sm8 sh_finan_sm3  sh_agri_sm3 sh_trade_sm3 sh_govt_sm3 if nv==0 &  extremeper_sm8!=., robust cluster(cntry)
predict resid_totunemp2, residuals
sum resid_totunemp2

xi: reg sh_const_sm3  sh_finan_sm3  sh_agri_sm3 sh_trade_sm3 sh_govt_sm3 if nv==0 & extremeper_sm8!=., robust cluster(cntry)
predict resid_shconst2, residuals
sum resid_shconst2

separate resid_totunemp2, by(group1)
separate resid_shconst2, by(group1)

sort nuts1 year 
gen L10resid_shconst2=L10.resid_shconst2 if year==2017

separate L10resid_shconst2, by(group1)


**Figure 5d:  Initial construction share and change in unemployment, before and after the crisis, controlling for industrial composition
***************************************************************************************************************************
twoway (scatter  L10resid_shconst2?  S9.resid_totunemp2 if year==2017,    mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    L10resid_shconst2 S9.resid_totunemp2,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Initial construction share and change in unemployment", size(small)) subtitle("Before and after the crisis, controlling for industrial composition", size(vsmall))  legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Initial share of employment in construction", size(small)) note("Source: Eurostat", size(vsmall))  
graph export "$files/figure5d.eps", as(eps) replace 




***************************************************************************************************************************
**Figure 6:  Vote to exit the EU and unemployment
***************************************************************************************************************************

use "$files/UK_data", clear

separate brexit_vote, by(id)


**Figure 6a: Total unemployment in 2014
***************************************************************************************************************************
twoway (scatter  brexit_vote?  totunemp ,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    brexit_vote totunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Vote to Exit the EU and Total Unemployment in 2014", size(medlarge)) subtitle(" ", size(vsmall)) legend (order (1 2 3 4)label(1 "England") label(2 "London") label(3 "Scotland") label(4 "Wales") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Total Unemployment in 2014", size(small)) xlabel(,labsize(small)) ytitle("Vote to exit the EU", size(small)) note("Source: ONS", size(vsmall))
graph export "$files/figure6a.eps", as(eps) replace 


**Figure 6b:  Change in unemployment, before and after the crisis
***************************************************************************************************************************
twoway (scatter  brexit_vote?  dtotunemp ,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    brexit_vote dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Vote to Exit the EU and Change in Unemployment", size(medlarge)) subtitle(" ", size(vsmall)) legend (order (1 2 3 4)label(1 "England") label(2 "London") label(3 "Scotland") label(4 "Wales") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Change in Unemployment", size(small)) xlabel(,labsize(small)) ytitle("Vote to exit the EU", size(small)) note("Source: ONS", size(vsmall))
graph export "$files/figure6b.eps", as(eps) replace 




***************************************************************************************************************************
**Figure 7: ESS Variables, General and political trust and unemployment before and after the crisis (NUTS 2, 24 countries)
***************************************************************************************************************************

use "$files/period_means_NUTS2.dta",clear

by nuts1: gen dtotunemp=(totunemp[2]-totunemp[1])
by nuts1: gen dgdp=(lppsgdp[2]-lppsgdp[1])
by nuts1: gen dppltrst_new=(ppltrst_new[2]-ppltrst_new[1])
by nuts1: gen dpplfair_new=(pplfair_new[2]-pplfair_new[1])
by nuts1: gen dpplhlp_new=(pplhlp_new[2]-pplhlp_new[1])
by nuts1: gen dtrstep_new=(trstep_new[2]-trstep_new[1])
by nuts1: gen dtrstun_new=(trstun_new[2]-trstun_new[1])
by nuts1: gen dtrstprl_new=(trstprl_new[2]-trstprl_new[1])
by nuts1: gen dtrstplt_new=(trstplt_new[2]-trstplt_new[1])
by nuts1: gen dtrstplc_new=(trstplt_new[2]-trstplc_new[1])
by nuts1: gen dtrstlgl_new=(trstlgl_new[2]-trstlgl_new[1])

separate dtotunemp, by(group1)
separate dgdp, by(group1)
separate dppltrst_new, by(group1)
separate dpplfair_new, by(group1)
separate dpplhlp_new, by(group1)
separate dtrstep_new, by(group1)
separate dtrstun_new, by(group1)
separate dtrstprl_new, by(group1)
separate dtrstplt_new, by(group1)
separate dtrstplc_new, by(group1)
separate dtrstlgl_new, by(group1)

keep  if time==0


**Figure 7a: General trust
***************************************************************************************************************************
twoway (scatter  dppltrst_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dppltrst_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Trust in other people", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend( order(1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in level of trust", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7a.eps", as(eps) replace 


**Figure 7b: Belief that people are helpful
***************************************************************************************************************************
twoway (scatter  dpplhlp_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dpplhlp_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Belief that people are helpful", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in belief", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7b.eps", as(eps) replace 


**Figure 7c: Trust in national parliament
***************************************************************************************************************************
twoway (scatter  dtrstprl_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dtrstprl_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Trust in national parliaments", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in level of trust", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7c.eps", as(eps) replace 


**Figure 7d: Trust in politicians
***************************************************************************************************************************
twoway (scatter  dtrstplt_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dtrstplt_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Trust in politicians", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in level of trust", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7d.eps", as(eps) replace 


**Figure 7e: Trust in European Parliament
***************************************************************************************************************************
twoway (scatter  dtrstep_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dtrstep_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Trust in European Parliament", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in level of trust", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7e.eps", as(eps) replace 


**Figure 7f: Trust in United Nations
***************************************************************************************************************************
twoway (scatter  dtrstun_new?  dtotunemp if nv2==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dtrstun_new dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Trust in the United Nations", size(small)) subtitle("Before and after the crisis", size(vsmall)) legend (order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in the unemployment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in level of trust", size(small)) note("Source: European Social Survey and Eurostat", size(vsmall))  
graph export "$files/figure7f.eps", as(eps) replace 




***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************
**Appendix Figures
***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************


***************************************************************************************************************************
**Appendix Figure 1: GDP pc and Unemployment
***************************************************************************************************************************


set more off

use "$files/voting_ESS_NUTS2", clear

set more off

gen time = 0
replace time=1 if year>2008

xi: areg totunemp i.year if nv1==0 & lppsgdp!=., absorb(nuts1)
predict resid1, residuals
sum resid1
xi: areg lppsgdp i.year if nv1==0 & totunemp!=., absorb(nuts1)
predict resid2, residuals
sum resid2
reg resid1 resid2
separate resid2, by(group1)


**Appendix Figure 1a: Log GDP per capita and % unemployment, 2000-15, controlling for region and time FE, NUTS 2 level 
***************************************************************************************************************************
twoway (scatter  resid2?  resid1,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2)) || (lfit    resid2 resid1,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Log GDP per capita and unemployment rate (percent), 2000-2015", size(medium)) subtitle("Controlling for region and time FE, NUTS 2 level", size(vsmall)) legend(order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(5) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Unemployment rate (percent)", size(small)) xlabel(,labsize(small)) ytitle("Log GDP per capita", size(small)) note("Source: Eurostat", size(vsmall))
graph export "$files/figureAppendix1a.eps", as(eps) replace 


***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************


use "$files/period_means_NUTS2.dta",clear
set more off

by nuts1: gen dtotunemp=(totunemp[2]-totunemp[1])
by nuts1: gen dgdp=(lppsgdp[2]-lppsgdp[1])

separate dgdp, by(group1)


**Appendix Figure 1b: Change in log GDP per capita and change in total unemployment, before and after the crisis
***************************************************************************************************************************
twoway (scatter  dgdp?  dtotunemp if nv1==0,   mcolor(red green blue orange)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dgdp dtotunemp,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Difference in log GDP per capita and difference in unemployment rate (percent)", size(medium)) subtitle("Before and after the crisis", size(vsmall)) legend( order (1 2 3 4) label(1 "Centre") label(2 "North") label(3 "South") label(4 "East") pos(5) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in unemployment rate(percent)", size(small)) xlabel(,labsize(small)) ytitle("Difference in log GDP per capita", size(small)) note("Source: Eurostat", size(vsmall)) 
graph export "$files/figureAppendix1b.eps", as(eps) replace


***************************************************************************************************************************
***************************************************************************************************************************
*************************************************************************************************************************** 


*************************************************************************************************************************** 
**Appendix Figure 2: Antiestablishment vote, before and after the crisis (NUTS 2, 26 countries)
***************************************************************************************************************************


set more off

use "$files/voting_ESS_NUTS2", clear

set more off

gen time = 0
replace time=1 if year>2008
	
	
**Appendix Figure 2a: Radical left vote
***************************************************************************************************************************
twoway histogram extreme_perel if time==0 & nv==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram extreme_perel if time==1  & nv==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Distribution of Voting for Radical Left Parties, Before and After the Crisis", size(small)) ///
subtitle("European Sample, NUTS2 Level", size(small)) ///
xtitle("Voting Share", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figureAppendix2a.eps", as(eps) replace 
	
	
**Appendix Figure 2b: Far-right vote
***************************************************************************************************************************
twoway histogram extreme_perer if time==0  & nv==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram extreme_perer if time==1 & nv==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Distribution of Voting for Far-Right Parties, Before and After the Crisis", size(small)) ///
subtitle("European Sample, NUTS2 Level", size(small)) ///
xtitle("Voting Share", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figureAppendix2b.eps", as(eps) replace 


**Appendix Figure 2c: Populist vote
***************************************************************************************************************************
twoway histogram extreme_perp if time==0 & nv==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram extreme_perp if time==1 & nv==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Distribution of Voting for Populist Parties, Before and After the Crisis", size(small)) ///
subtitle("European Sample, NUTS2 Level", size(small)) ///
xtitle("Voting Share", size(small)) ///
graphregion(color(white)) plotregion(color(white))
graph export "$files/figureAppendix2c.eps", as(eps) replace 


**Appendix Figure 2d: Eurosceptic/separatist vote
***************************************************************************************************************************
twoway histogram extreme_perae if time==0 & nv==0, ///
bfcolor(ltblue) blcolor(ltblue)          ///
|| histogram extreme_perae if time==1 & nv==0,   ///
bfcolor(none) blcolor(red)                                    ///
legend(order(1 "Before the Crisis" 2 "After the Crisis") col(2)) ///
title("Distribution of Voting for Eurosceptic Parties, Before and After the Crisis", size(small)) ///
subtitle("European Sample, NUTS2 Level", size(small)) ///
xtitle("Voting Share", size(small)) ///
graphregion(color(white)) plotregion(color(white)) 
graph export "$files/figureAppendix2d.eps", as(eps) replace 




***************************************************************************************************************************
**Appendix Figure 3: Antiestablishment voting and employment rates before and after the crisis (NUTS 3, 11 countries)
***************************************************************************************************************************

use "$files/voting_NUTS3.dta", clear
set more off	   
	   
encode cntry, gen (cntry1)	
   
gen time=0
replace time=1 if year>2008
collapse (mean) iv 	Electorate	Voters	ValidVotes	part  rowtotal	extreme_per	extreme_perer extreme_perel extreme_perp extreme_perae 	emp_pop, by(nuts1 cntry1 groupa time)		  

save "$files/period_means_NUTS3.dta",replace

by nuts1: gen demp_pop=(emp_pop[2]-emp_pop[1])
by nuts1: gen dextreme_per=(extreme_per[2]-extreme_per[1])

separate demp_pop, by(groupa)
separate dextreme_per, by(groupa)

keep  if time==0


**Appendix Figure 3a: Antiestablishment vote
***************************************************************************************************************************
twoway (scatter  dextreme_per?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_per demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Anti-establishment parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3a.eps", as(eps) replace 




use "$files/voting_NUTS3.dta", clear
set more off
	   
encode cntry, gen (cntry1)	
   
gen time=0
replace time=1 if year>2008
collapse (mean) iv 	Electorate	Voters	ValidVotes	part  rowtotal	extreme_per	extreme_perer extreme_perel extreme_perp extreme_perae 	emp_pop, by(nuts1 cntry1 groupa time)		  

save "$files/period_means_NUTS3.dta",replace

by nuts1: gen demp_pop=(emp_pop[2]-emp_pop[1])
by nuts1: gen dextreme_per=(extreme_per[2]-extreme_per[1])
by nuts1: gen dextreme_perel=(extreme_perel[2]-extreme_perel[1])
by nuts1: gen dextreme_perer=(extreme_per[2]-extreme_perer[1])
by nuts1: gen dextreme_perp=(extreme_perp[2]-extreme_perp[1])
by nuts1: gen dextreme_perae=(extreme_perae[2]-extreme_perae[1])
by nuts1: gen dpart=(part[2]-part[1])

separate demp_pop, by(groupa)
separate dextreme_per, by(groupa)
separate dextreme_perel, by(groupa)
separate dextreme_perer, by(groupa)
separate dextreme_perp, by(groupa)
separate dextreme_perae, by(groupa)
separate dpart, by(groupa)

keep  if time==0

**Appendix Figure 3b: Radical left vote
***************************************************************************************************************************
twoway (scatter  dextreme_perel?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perel demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Radical left parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3b.eps", as(eps) replace


**Appendix Figure 3c: Far-right vote
***************************************************************************************************************************
twoway (scatter  dextreme_perer?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perer demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Far-right parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3c.eps", as(eps) replace


**Appendix Figure 3d: Populist vote
***************************************************************************************************************************
twoway (scatter  dextreme_perp?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perp demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Populist parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3d.eps", as(eps) replace


**Appendix Figure 3e: Eurosceptic/separatist vote
***************************************************************************************************************************
twoway (scatter  dextreme_perae?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dextreme_perae demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Eurosceptic parties", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting share", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3e.eps", as(eps) replace


**Appendix Figure 3f: Participation
***************************************************************************************************************************
twoway (scatter  dpart?  demp_pop if iv==3,   mcolor(blue red)  msize(small) mlabpos(12) mlabsize(2))  || (lfit    dpart demp_pop,  fcolor(none) alpattern(dash) fintensity(inten10) clwidth(medthick)), title("Voting participation", size(small)) subtitle("Before and After the Crisis", size(vsmall)) legend(order (1 2) label(1 "Periphery") label(2 "Core")  pos(6) ring(0) col(5) bmargin(tiny)) graphregion(color(white)) plotregion(color(white)) xtitle("Difference in employment rate", size(small)) xlabel(,labsize(small)) ytitle("Difference in voting participation", size(small)) note("Source: National Election Sources and Cambridge Econometrics", size(vsmall)) 
graph export "$files/figureAppendix3f.eps", as(eps) replace




***************************************************************************************************************************
***************************************************************************************************************************
***************************************************************************************************************************
